/*
 * NetworkStructure.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef NETWORKSTRUCTURE_H_
#define NETWORKSTRUCTURE_H_




#include <StandardLibs.h>
#include <IgraphVersionCompile.h>


typedef struct {
	// Initial conditions
	long int start_node;
	long int start_node2;
	int sample_random_start_nodes = 0;

	int use_dqueue_initial_cond;
	// if use_dqueue_initial_cond is set to 1 then we are using dq_infected_nodes
	// queue as initial condition

	// STATIC UNDIRECTED and UNWEIGHTED network
    igraph_adjlist_t *al;
    igraph_dqueue_t * dq_infected_nodes;
    igraph_t * p_graph;
    long int no_of_nodes;
    //here we insert all infected nodes during simulation
    igraph_dqueue_t * q_infected_nodes_all;

    int print_recovered;

    // TEMPORAL NETWORK: if network is adaptive then its structure in time is represented with contact_arrays with appropriate time_contacts_array
    int use_temporal_network_structure;
    vector<int> * contact_array_1;
    vector<int> * contact_array_2;
    vector<int> * time_contact_array;
    // if (randomize_temporal_contacts == 1) then we randomize network structure
    int randomize_temporal_contacts = 0; // default value - no randomization
    int randomize_null_model_uniformly = 0; //default null model is permuation
    int delta = 0; // size of bin for temporal randomization, default does not randomize
    int zero_time = -99999; //time of the first interactions (reference point)

    // WEIGHTED DIRECTED NEWORK : if network is weighted then we have static connections plus weights
    int use_weighted_static_network = 0;
    igraph_spmatrix_t *weight_mat; // target, source, weight - column wise fetching is faster


} infected_structure;
// refactor the name to -> network_structure

void init_infected_structure(const char *input_file_name, const char *file_type, infected_structure * p_infected_parameters);

void init_infected_structure_from_graph(infected_structure * p_infected_parameters, igraph_t * graph );

void destroy_infected_structure(infected_structure * p_infected_parameters);

unsigned int getRandomNode(int num_nodes);

void read_temporal_contacts(FILE *fp, infected_structure * p_infected_parameters);

void read_weighted_network(FILE *fp, igraph_spmatrix_t * mat_weight, igraph_t * graph_G);

long int read_max_node_id_from_weighted_file(FILE *fp);

void aggregate_temporal_network(infected_structure * p_infected_parameters, igraph_t * graph_G);

#endif /* NETWORKSTRUCTURE_H_ */
